﻿/*
WHAT THIS DOES:
	This moves a movieClip to a specific tile.
	
PARAMETERS:
	moveSystem		(needed)		The event system for this sequence of movements.		Used to determine which sprite to use.		Used to trigger next movement / event.
	xDest					(optional)		Destination x tile to move to.
	yDest					(optional)		Destination y tile to move to.
	autoPose			(optional)		Whether to automatically set the sprite's direction  &  animation.
	speed				(optional)		How many seconds it takes to move 1 tile.
	
USAGE:
(synchronous)		(sequence of movements)
	talkEvents.push( function(){			move = makeEventSystem( _this );		// define movement
														move.push( function(){			event_moveAbsolute(move, -1, 0);		});
														move.push( function(){			event_moveAbsolute(move, 0, -1);		});
														move.push( function(){			event_moveAbsolute(move, 1, 0);		});
														move.push( function(){			event_moveAbsolute(move, 0, 1);		});
														move.push( function(){			_this.image_mc.setAnim( false );
																									talkEvents.nextEvent();		});
													move.runEvent(0);								// start movement
													});
	
USAGE:
(asynchronous)		(sequence of movements)
	talkEvents.push( function(){			move = makeEventSystem( _this );		// define movement
														move.push( function(){			event_moveAbsolute(move, -1, 0);		});
														move.push( function(){			event_moveAbsolute(move, 0, -1);		});
														move.push( function(){			event_moveAbsolute(move, 1, 0);		});
														move.push( function(){			event_moveAbsolute(move, 0, 1);		});
														move.push( function(){			_this.image_mc.setAnim( false );		});
													move.runEvent(0);								// start movement
													talkEvents.nextEvent();		});
	
USAGE:
(a single movement)
	talkEvents.push( function(){		event_moveAbsolute(talkEvents, -1, 0);		});
	
EXPLAINATION:
	To create a sequence of movements, simply define a 2nd eventSystem and run it.
	When defining it, tell it which sprite to move like so:
		move = makeEventSystem( mySprite_mc );
	
NOTE:
	Any event command can be placed within the movement sequence.
	Likewise, a single move command can be used as a normal event.
	
NOTE:
	autoPose will make the sprite start animating,
	but it won't make it stop.
	You need to do that manually.
*/
if(!ZigoEngine)
{
	import com.mosesSupposes.fuse.*;
	ZigoEngine.simpleSetup(Shortcuts,PennerEasing);
}



_global.event_moveTo = function( moveSystem, xDest, yDest, autoPose, speed, thisSprite )
{
	// resolve optional parameters
	var xDest = (xDest) ? xDest : (moveSystem.sprite._x / 16);		// default:  don't move
	var yDest = (yDest) ? yDest : (moveSystem.sprite._y / 16);		// default:  don't move
	var autoPose = (autoPose!=undefined) ? autoPose : true;			// default:  ON
	var speed = (speed) ? speed : 0.26;						// default:  0.26 seconds to move 1 tile
	var thisSprite = (thisSprite) ? thisSprite : moveSystem.sprite;		// default:  calling sprite
	
	var thisSprite = moveSystem.sprite;
	
	// set destination coordinates
	var xPix = xDest*16;
	var yPix = yDest*16;
	
	// calculate time
	var xDiff = xDest - (moveSystem.sprite._x / 16);
	var yDiff = yDest - (moveSystem.sprite._y / 16);
	var dist = Math.sqrt( (xDiff*xDiff) + (yDiff*yDiff) );		// overall distance being traveled, in tiles
	var delay = speed * dist;
	
	if(autoPose)
	{
		if( Math.abs(xDiff) < Math.abs(yDiff) )
		{
			if(yDiff < 0){	thisSprite.image_mc.setDirection("up");		}
			if(yDiff > 0){	thisSprite.image_mc.setDirection("down");		}
		}else{
			if(xDiff < 0){	thisSprite.image_mc.setDirection("left");		}
			if(xDiff > 0){	thisSprite.image_mc.setDirection("right");		}
		}
		if( xDiff  ||  yDiff ){
			thisSprite.image_mc.setAnim( true );
		}
	}// if:  autoPose
	
	// do movement
	moveSystem.sprite.slideTo( xPix, yPix, delay, "linear", 0, moveSystem.nextEvent );
}// event_moveTo()